#include  "StdAfx.h"
#include  "MenuHandlerBase.hpp"
#include  "DllMain.h"
#include  "Scope.hpp"
#include  <szFile.hpp>
#include  <szPath.hpp>
#include  <szVersion.hpp>
#include  <buffers.hpp>

using namespace szpp;

CMenuHandlerBase::CMenuHandlerBase() : m_HasFile(false), m_DirPath(), m_ArchiveStem(), m_Files(), m_BitmapManager()
{
}

CMenuHandlerBase::~CMenuHandlerBase()
{
}

HRESULT CMenuHandlerBase::InitializeImpl(__in PCIDLIST_ABSOLUTE pidlFolder, __in IDataObject *pdtobj, __in HKEY hkeyProgID)
{
  if (0 == pdtobj)
    return E_POINTER;

  m_Files.clear();
  m_HasFile = false;

  FORMATETC fe = { CF_HDROP, 0, DVASPECT_CONTENT, -1 , TYMED_HGLOBAL };
  STGMEDIUM stg = { TYMED_HGLOBAL };

  if (FAILED(pdtobj->GetData(&fe, &stg)))
    return E_INVALIDARG;

  StgMediumScope stgScope(&stg);
  GlobalLockScope globalLockScope(stg.hGlobal);
  HDROP hDrop = (HDROP)globalLockScope.Get();
  if (0 == hDrop)
    return E_INVALIDARG;

  UINT uNumFiles = DragQueryFile(hDrop, ~0, 0, 0);
  if (0 == uNumFiles)
    return E_INVALIDARG;

  HRESULT hr = S_OK;
  sbuf<szchar, MAX_PATH> path;
  for (UINT i = 0; i < uNumFiles && hr == S_OK; ++i)
  {
    if(0 == DragQueryFile(hDrop, i, path, path.size()))
      return E_FAIL;

    const szstring fullPath((szchar *)path);
    m_Files.push_back(fullPath);

    // epo ɂ͓OWJ@\Ȃ߁At@CIĂȂƂɂ͓WJj[\Ȃ
    if (FileExists(fullPath))
      m_HasFile = true;
  }

  // efBNg̃pX擾Ă
  m_DirPath = ExtractDirectory(m_Files[0]);
  m_ArchiveStem = ExtractStem(uNumFiles > 1 ? m_DirPath : m_Files[0]);

  return S_OK;
}

void CMenuHandlerBase::InsertItem(HMENU hmenu, UINT index, UINT uID, const szchar *text, int nIconID)
{
  if (nIconID < 0)
  {
    InsertMenu(hmenu, index, MF_BYPOSITION, uID, text);
    return;
  }

  if (wVersion <= OS_VERSION_2K)
  {
    InsertMenu(hmenu, index, MF_BYPOSITION | MF_STRING , uID, text);
    // on win2k, the context menu does not work properly if we use
    // icon bitmaps. At least the menu text is empty in the context menu
    // for folder backgrounds (seems like a win2k bug).
    //
    // \ƂŌĥŁAW2K ł̓ACRȂłB
    //HBITMAP bmp = m_BitmapManager.IconToBitmap(nIconID); 
    //SetMenuItemBitmaps(hmenu, index, MF_BYPOSITION, bmp, bmp);
    return;
  }

  // ACR
  //   Vista ȂAt@trbg}bvݒ肵AXP ȂI[i[`ŃACR𒼐ڕ`悷
  MENUITEMINFO mii = { sizeof(MENUITEMINFO) };
  mii.fMask = MIIM_BITMAP | MIIM_STRING | MIIM_ID | MIIM_FTYPE;
  mii.fType = MFT_STRING;
  mii.dwTypeData = (szchar *)text;
  mii.hbmpItem = (wVersion >= OS_VERSION_VISTA ? m_BitmapManager.IconToBitmapARGB(nIconID) : HBMMENU_CALLBACK);
  mii.wID = uID;
  InsertMenuItem(hmenu, index, TRUE, &mii);
}

HRESULT CMenuHandlerBase::MenuMessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
  switch (uMsg)
  {
  case WM_MEASUREITEM:
    {
      *pResult = TRUE;

      MEASUREITEMSTRUCT *lpmis = (MEASUREITEMSTRUCT *)lParam;
      if (lpmis != 0)
      {
        lpmis->itemWidth += 2;
        if (lpmis->itemHeight < 16)
          lpmis->itemHeight = 16;
      }
    }
    return S_OK;
  case WM_DRAWITEM:
    {
      *pResult = TRUE;

      DRAWITEMSTRUCT *lpdis = (DRAWITEMSTRUCT *)lParam;
      if ((lpdis == NULL) || (lpdis->CtlType != ODT_MENU))
        return S_OK;

      HBITMAP hBitmap = 0;
      UINT iconID = MenuIdToIconID(lpdis->itemID);
      if (iconID == ~0)
        return S_OK;

      // XP ̏ꍇ͂ŃACR`
      IconScope icon((HICON)LoadImage(hDllInstance, MAKEINTRESOURCE(iconID), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));
      if ((HICON)icon == NULL)
        return S_OK;
      DrawIconEx(lpdis->hDC,
        lpdis->rcItem.left - 16,
        lpdis->rcItem.top + (lpdis->rcItem.bottom - lpdis->rcItem.top - 16) / 2,
        icon, 16, 16, 0, NULL, DI_NORMAL);
    }
    return S_OK;
  }
  return S_OK;
}
